%{
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>

#include "amain.h"

#define C               the_str[the_ptr]
#define C1              the_str[the_ptr+1]

#define YYDEBUG         1

char                    the_str[512];
int                     the_ptr = 0;
int                     prevx;
int                     running = 0;
int                     onerrgoto = 0;

typedef struct
{
  int type;
  long offset;
  double d;
  long l;
  int i;
  char ord[512];
} VALUE;

%}


%union {
  VALUE v;
}

%token <v> INTEGER
%token <v> NUMBER
%token <v> STRING
%token <v> IDENTIFIER
%token <v> STRINGVAR
%token <v> INTEGERVAR
%token KEYWORD

%token End For Next Data Input Del Dim Read
%token Gr Text Pr In Call Plot Hlin Vlin
%token Hgr2 Hgr Hcolor Hplot Draw Xdraw Htab Home
%token Rot Scale Shload Trace Notrace Normal Inverse Flash
%token Color Pop Vtab Himem Lomem Onerr Resume Recall
%token Store Speed Let Goto Run If Restore Amper
%token <v> Gosub Return Rem Stop On Wait Load Save
%token Def Poke Print Cont List Clear Get New
%token Tab To Fn Spc Then At Not Step
%token And Or
%token Sgn Int Abs Usr Fre Scrn
%token Pdl Pos Sqr Rnd Log Exp Cos Sin
%token Tan Atn Peek Len Str Val Asc Chr
%token Left Right Mid

%left ':'
%left Or And Not
%left '>' '=' '<'
%left '+' '-'
%left '*' '/' '^'

%type <v> expr
%type <v> exprs

%%

program:
	lines 

lines:
|
	line 
|
	lines line 
|
	lines '\n'

line:
	INTEGER compound_statement '\n'
	{
		if (!running)
			reg_line($1.i,$1.offset);
	}

compound_statement:
	statement
	{
	}
|
	compound_statement '\n' statement
	{
	}
|
	compound_statement ':' statement
	{
	}

statement:
	Rem
	{
	}
|
	Goto INTEGER
	{
		if (running)
		{
		}
	}
|
	STRINGVAR '=' expr
	{
		if (running)
			set_stringvar($1.ord,$3.ord);
	}
|
	INTEGERVAR '=' expr
	{
		if (running)
			set_integervar($1.ord,$3.l);
	}
|
	IDENTIFIER '=' expr
	{
		if (running)
			set_var($1.ord,$3.l);
	}
|
	STRINGVAR '(' expr ')' '=' expr
	{
		if (running)
			set_stringvar_index($1.ord,$3.l,$6.ord);
	}
|
	INTEGERVAR '(' expr ')' '=' expr
	{
		if (running)
			set_integervar_index($1.ord,$3.l,$6.l);
	}
|
	IDENTIFIER '(' expr ')' '=' expr
	{
		if (running)
			set_var_index($1.ord,$3.l,$6.l);
	}
|
	Onerr Goto INTEGER
	{
		onerrgoto = $3.i;
	}
|
	Print
	{
		if (running)
			printf("\n");
	}
|
	Print exprs
	{
		if (running)
			printf("%s\n",$2.ord);
	}
|
	Print exprs ';'
	{
		if (running)
			printf("%s",$2.ord);
	}
|
	Input varlist
|
	Input STRING ';' varlist
|
	For IDENTIFIER '=' expr To expr
|
	Next
|
	Next IDENTIFIER
|
	Def Fn IDENTIFIER '(' expr ')' '=' expr
|
	Get expr
|
	If expr Then INTEGER
|
	If expr Then statement
|
	On expr Goto intlist
|
	Gosub INTEGER
|
	Return
|
	Home
|
	Vtab expr
|
	Poke expr ',' INTEGER
|
	Inverse
|
	Normal
|
	End

exprs:
	expr
	{
		$$ = $1;
	}
|
	exprs ';' expr
	{
		sprintf($$.ord,"%s%s",$1.ord,$3.ord);
	}
|
	exprs ',' expr
	{
		sprintf($$.ord,"%s%s",$1.ord,$3.ord);
	}

expr:
	INTEGER
|
	NUMBER
|
	STRING
|
	IDENTIFIER
|
	STRINGVAR
|
	INTEGERVAR
|
	IDENTIFIER '(' expr ')'
|
	STRINGVAR '(' expr ')'
|
	INTEGERVAR '(' expr ')'
|
	'-' expr
	{
		$$.d = -$2.d;
		$$.l = -$2.l;
		$$.i = -$2.i;
	}
|
	expr '+' expr
	{
		$$.d = $1.d + $3.d;
		$$.l = $1.l + $3.l;
		$$.i = $1.i + $3.i;
		sprintf($$.ord,"%s%s",$1.ord,$3.ord);
	}
|
	expr '-' expr
	{
		$$.d = $1.d - $3.d;
		$$.l = $1.l - $3.l;
		$$.i = $1.i - $3.i;
	}
|
	expr '*' expr
	{
		$$.d = $1.d * $3.d;
		$$.l = $1.l * $3.l;
		$$.i = $1.i * $3.i;
	}
|
	expr '/' expr
	{
		$$.d = $1.d / $3.d;
		$$.l = $1.l / $3.l;
		$$.i = $1.i / $3.i;
	}
|
	expr '<' expr
	{
		$$.type = INTEGER;
		if ($1.type == STRING)
		{
			$$.i = (strcmp($1.ord,$3.ord) < 0) ? 1 : 0;
		}
		else
		if ($1.type == NUMBER)
		{
			$$.i = ($1.d < $3.d) ? 1 : 0;
		}
		else
		{
			$$.i = ($1.l < $3.l) ? 1 : 0;
		}
	}
|
	expr '>' expr
	{
		$$.type = INTEGER;
		if ($1.type == STRING)
		{
			$$.i = (strcmp($1.ord,$3.ord) > 0) ? 1 : 0;
		}
		else
		if ($1.type == NUMBER)
		{
			$$.i = ($1.d > $3.d) ? 1 : 0;
		}
		else
		{
			$$.i = ($1.l > $3.l) ? 1 : 0;
		}
		$$.d = $$.l = $$.i;
	}
|
	expr '<' '>' expr
	{
		$$.type = INTEGER;
		if ($1.type == STRING)
		{
			$$.i = strcmp($1.ord,$4.ord);
		}
		else
		if ($1.type == NUMBER)
		{
			$$.i = ($1.d != $4.d) ? 1 : 0;
		}
		else
		{
			$$.i = ($1.l != $4.l) ? 1 : 0;
		}
		$$.d = $$.l = $$.i;
	}
|
	expr Or expr
	{
		$$.type = INTEGER;
		$$.d = $$.l = $$.i = ($1.i || $3.i) ? 1 : 0;
	}
|
	expr And expr
	{
		$$.type = INTEGER;
		$$.d = $$.l = $$.i = ($1.i && $3.i) ? 1 : 0;
	}
|
	expr '=' expr
	{
		$$.type = INTEGER;
		if ($1.type == STRING)
		{
			$$.i = !strcmp($1.ord,$3.ord);
		}
		else
		if ($1.type == NUMBER)
		{
			$$.i = ($1.d == $3.d) ? 1 : 0;
		}
		else
		{
			$$.i = ($1.l == $3.l) ? 1 : 0;
		}
		$$.d = $$.l = $$.i;
	}
|
	Chr '(' expr ')'
	{
		$$.ord[0] = $3.l;
		$$.ord[1] = 0;
	}
|
	Int '(' expr ')'
|
	Val '(' expr ')'
|
	Rnd '(' expr ')'
|
	'(' expr ')'
|
	Not expr
|
	Mid '(' expr ',' expr ',' expr ')'
|
	Fn IDENTIFIER '(' expr ')'
|
	Left '(' expr ',' expr ')'
|
	Len '(' expr ')'
|
	Str '(' expr ')'
|
	Spc '(' expr ')'
|
	Abs '(' expr ')'
|
	Tab '(' expr ')'
|
	Peek '(' expr ')'

intlist:
	INTEGER
|
	intlist ',' INTEGER

varlist:
	STRINGVAR
|
	INTEGERVAR
|
	IDENTIFIER
|
	STRINGVAR '(' expr ')'
|
	INTEGERVAR '(' expr ')'
|
	IDENTIFIER '(' expr ')'
|
	varlist ',' STRINGVAR
|
	varlist ',' INTEGERVAR
|
	varlist ',' IDENTIFIER
|
	varlist ',' STRINGVAR '(' expr ')'
|
	varlist ',' INTEGERVAR '(' expr ')'
|
	varlist ',' IDENTIFIER '(' expr ')'

%%


void set_stringvar(char *name,char *value)
{
	printf("%s = '%s'\n",name,value);
}

void set_integervar(char *name,long value)
{
	printf("%s = %ld\n",name,value);
}

void set_var(char *name,long value)
{
	printf("%s = %ld\n",name,value);
}

void set_stringvar_index(char *name,long index,char *value)
{
	printf("%s[%ld] = '%s'\n",name,index,value);
}

void set_integervar_index(char *name,long index,long value)
{
	printf("%s[%ld] = %ld\n",name,index,value);
}

void set_var_index(char *name,long index,long value)
{
	printf("%s[%ld] = %ld\n",name,index,value);
}

void reg_line(int line,long offset)
{
}


/*
	"END", "FOR", "NEXT", "DATA", "INPUT", "DEL", "DIM", "READ",
	"GR", "TEXT", "PR #", "IN #", "CALL", "PLOT", "HLIN", "VLIN",
	"HGR2", "HGR", "HCOLOR=", "HPLOT", "DRAW", "XDRAW", "HTAB", "HOME",
	"ROT=", "SCALE=", "SHLOAD", "TRACE", "NOTRACE", "NORMAL", "INVERSE", "FLASH",
	"COLOR=", "POP", "VTAB ", "HIMEM:", "LOMEM:", "ONERR", "RESUME", "RECALL",
	"STORE", "SPEED=", "LET", "GOTO", "RUN", "IF", "RESTORE", "&",
	"GOSUB", "RETURN", "REM", "STOP", "ON", "WAIT", "LOAD", "SAVE",
	"DEF FN", "POKE", "PRINT", "CONT", "LIST", "CLEAR", "GET", "NEW",
	"TAB", "TO", "FN", "SPC(", "THEN", "AT", "NOT", "STEP",
	"+", "-", "*", "/", "^", "AND", "OR", ">",
	"=", "<", "SGN", "INT", "ABS", "USR", "FRE", "SCRN (",
	"PDL", "POS", "SQR", "RND", "LOG", "EXP", "COS", "SIN",
	"TAN", "ATN", "PEEK", "LEN", "STR$", "VAL", "ASC", "CHR$",
	"LEFT$", "RIGHT$", "MID$", "", "", "", "", "",
	"", "", "", "", "", "", "", "",
	"", "", "", "", "", "(", "(", "(",
*/
char *keywords[] = {
/* 80 */
	"END", "FOR", "NEXT", "DATA", "INPUT", "DEL", "DIM", "READ",
/* 88 */
	"GR", "TEXT", "PR", "IN", "CALL", "PLOT", "HLIN", "VLIN",
/* 90 */
	"HGR2", "HGR", "HCOLOR", "HPLOT", "DRAW", "XDRAW", "HTAB", "HOME",
/* 98 */
	"ROT", "SCALE", "SHLOAD", "TRACE", "NOTRACE", "NORMAL", "INVERSE", "FLASH",
/* A0 */
	"COLOR", "POP", "VTAB", "HIMEM", "LOMEM", "ONERR", "RESUME", "RECALL",
/* A8 */
	"STORE", "SPEED", "LET", "GOTO", "RUN", "IF", "RESTORE", "&",
/* B0 */
	"GOSUB", "RETURN", "REM", "STOP", "ON", "WAIT", "LOAD", "SAVE",
/* B8 */
	"DEF", "POKE", "PRINT", "CONT", "LIST", "CLEAR", "GET", "NEW",
/* C0 */
	"TAB", "TO", "FN", "SPC", "THEN", "AT", "NOT", "STEP",
/* C8 */
	"+", "-", "*", "/", "^", "AND", "OR", ">",
/* D0 */
	"=", "<", "SGN", "INT", "ABS", "USR", "FRE", "SCRN",
/* D8 */
	"PDL", "POS", "SQR", "RND", "LOG", "EXP", "COS", "SIN",
/* E0 */
	"TAN", "ATN", "PEEK", "LEN", "STR$", "VAL", "ASC", "CHR$",
/* E8 */
	"LEFT$", "RIGHT$", "MID$", "", "", "", "", "",
/* F0 */
	"", "", "", "", "", "", "", "",
/* F8 */
	"", "", "", "", "", "(", "(", "(",
        ""
};

int tokens[] = {
  End, For, Next, Data, Input, Del, Dim, Read,
  Gr, Text, Pr, In, Call, Plot, Hlin, Vlin,
  Hgr2, Hgr, Hcolor, Hplot, Draw, Xdraw, Htab, Home,
  Rot, Scale, Shload, Trace, Notrace, Normal, Inverse, Flash,
  Color, Pop, Vtab, Himem, Lomem, Onerr, Resume, Recall,
  Store, Speed, Let, Goto, Run, If, Restore, Amper,
  Gosub, Return, Rem, Stop, On, Wait, Load, Save,
  Def, Poke, Print, Cont, List, Clear, Get, New,
  Tab, To, Fn, Spc, Then, At, Not, Step,
  '+', '-', '*', '/', '^', And, Or, '>',
  '=', '<', Sgn, Int, Abs, Usr, Fre, Scrn,
  Pdl, Pos, Sqr, Rnd, Log, Exp, Cos, Sin,
  Tan, Atn, Peek, Len, Str, Val, Asc, Chr,
  Left, Right, Mid, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, '(', '(', '(',
  -1
};

void yy_init(int r)
{
  *the_str = 0;
  the_ptr = 0;
  running = r;
}

void yyerror(char *s)
{
  int i;

  printf("Line %d:\n",line);
  printf("%s\n",the_str);
  for (i = 0; i < prevx; i++)
    printf(" ");
  printf("^ yyerror: %s\n",s);
}

int yylex()
{
  int token;
  int x;
  char c;

  while (C == ' ' || C == 9)
  {
    the_ptr++;
  }
  while (!C)
  {
    if (eof())
    {
      return 0;
    }
    x = the_ptr;
    fget(the_str, 512);
    the_ptr = 0;
    if (eof())
    {
      *the_str = 0;
    }
    while (C == ' ' || C == 9)
    {
      the_ptr++;
    }
    if (x)
    {
      return '\n';
    }
  }
  prevx = the_ptr;
  yylval.v.offset = tell();
  yylval.v.type = 0;
  if ((C == '-' && isdigit(C1)) || isdigit(C) || C == '.')
  {
    token = INTEGER;
    x = the_ptr;
    while (isdigit(C) || C == '.')
    {
      if (C == '.')
      {
        token = NUMBER;
      }
      the_ptr++;
    }
    strncpy(yylval.v.ord,the_str + x,the_ptr - x);
    yylval.v.ord[the_ptr - x] = 0;
    yylval.v.type = token;
    yylval.v.i = atoi(yylval.v.ord);
    yylval.v.l = atol(yylval.v.ord);
    yylval.v.d = atof(yylval.v.ord);
    return token;
  }
  if (isalpha(C))
  {
    token = IDENTIFIER;
    x = the_ptr;
    while (isalnum(C))
    {
      the_ptr++;
    }
    if (C == '$')
    {
      the_ptr++;
      token = STRINGVAR;
      yylval.v.type = STRING;
    }
    else
    if (C == '%')
    {
      the_ptr++;
      token = INTEGERVAR;
      yylval.v.type = INTEGER;
    }
    strncpy(yylval.v.ord,the_str + x,the_ptr - x);
    yylval.v.ord[the_ptr - x] = 0;
    for (x = 0; tokens[x] != -1; x++)
    {
      if (!strcasecmp(keywords[x],yylval.v.ord))
      {
        if (tokens[x] == Rem)
        {
          while (C == ' ' || C == 9)
          {
            the_ptr++;
          }
          strcpy(yylval.v.ord,the_str + the_ptr);
          C = 0;
        }
        return tokens[x];
      }
    }
    return token;
  }
  if (C == '"')
  {
    x = the_ptr++;
    while (C != '"' && C)
    {
      the_ptr++;
    }
    if (C == '"')
    {
      the_ptr++;
    }
    strncpy(yylval.v.ord,the_str + x + 1,the_ptr - x - 1);
    yylval.v.ord[the_ptr - x - 2] = 0;
    yylval.v.type = STRING;
    return STRING;
  }
  c = C;
  the_ptr++;
  return c;
}

